const createParams = (req, res, next) => {
  const { username, password,name } = req.body;

  // Check if both username 
  if (!username) {
    return res.status(400).json({
      message: "Username is required",
    });
  }

  // Check if both password 
  if (!password) {
    return res.status(400).json({
      message: "password is required",
    });
  }

  // Check if both password 
  if (!name) {
    return res.status(400).json({
      message: "name is required",
    });
  }

   // Regular expression to check for any special characters
   const nameRegex = /^[a-zA-Z\s]+$/;  // Allows only alphabets and spaces

   // Check if name contains only letters and spaces
   if (!nameRegex.test(name)) {
     return res.status(400).json({
       message: 'Name should only contain alphabets and spaces, no special characters allowed'
     });
   }

  // Regular expression to validate email format (basic email format validation)
  const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
   // Check if the email matches the regex
   if (!emailRegex.test(username)) {
    return res.status(400).json({
      message: 'Invalid email format'
    });
  }

  // Validate password strength (example: at least 8 characters, contains a number)
  const passwordStrengthRegex = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$/;
  if (!passwordStrengthRegex.test(password)) {
    return res.status(400).json({
      message:
        "Password must be at least 8 characters long and contain at least one number, one uppercase letter, and one lowercase letter.",
    });
  }

  

 

  // If validation passes, move to the next middleware/controller
  next();
};

const loginParams = (req, res, next) => {
    const { username, password,name } = req.body;
  
    // Check if both username 
    if (!username) {
      return res.status(400).json({
        message: "Username is required",
      });
    }
  
    // Check if both password 
    if (!password) {
      return res.status(400).json({
        message: "password is required",
      });
    }

    // Regular expression to validate email format (basic email format validation)
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
     // Check if the email matches the regex
     if (!emailRegex.test(username)) {
      return res.status(400).json({
        message: 'Invalid email format'
      });
    }
  
    // Validate password strength (example: at least 8 characters, contains a number)
    const passwordStrengthRegex = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$/;
    if (!passwordStrengthRegex.test(password)) {
      return res.status(400).json({
        message:
          "Password must be at least 8 characters long and contain at least one number, one uppercase letter, and one lowercase letter.",
      });
    }
  
    // If validation passes, move to the next middleware/controller
    next();
  };

module.exports = {
    createParams,
    loginParams
};
