const { DataTypes } = require('sequelize');
const sequelize = require('../../config/database'); // Update with your database connection file path

const Vendor = sequelize.define('Vendor', {
  company_name: {
    type: DataTypes.STRING,
    allowNull: false
  },
  email: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      isEmail: true
    }
  },
  password: {
    type: DataTypes.STRING,
    allowNull: false
  },
  mobile_number: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      len: [10, 15] // Adjust length based on requirements
    }
  },
  auth_token: {
    type: DataTypes.STRING,
    allowNull: true
  },
  verified_at: {
    type: DataTypes.DATE,
    allowNull: true
  },
  updated_at: {
    type: DataTypes.DATE,
    defaultValue: DataTypes.NOW
  },
  created_at: {
    type: DataTypes.DATE,
    defaultValue: DataTypes.NOW
  },
  review_average: {
    type: DataTypes.FLOAT,
    defaultValue: 0.0
  },
  sorting: {
    type: DataTypes.INTEGER,
    defaultValue: 0
  },
  category_name: {
    type: DataTypes.STRING,
    allowNull: true
  },
  category_id: {
    type: DataTypes.INTEGER,
    allowNull: true
  },
  url: {
    type: DataTypes.STRING,
    allowNull: true
  },
  referred_by: {
    type: DataTypes.INTEGER,
    allowNull: true
  },
  status: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
  is_on: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  }
}, {
  timestamps: false,
  tableName: 'vendors'
});

module.exports = Vendor;
